function res = chris_injection()
%
% Processes spikes in response to step current injection. Fits the NSpikes data, and returns the
% fit curve parameters.

% Sep 17 2012: Rev.
% Oct 09 2013: Adapting it for the spikerbox data.
% Aug 14 2014: Updated for new data. Also now it works with all records, not with a selected list of them.
% Aug 15 2014: Optimized reporting; better fit margins & starting points.
% Jan 17 2015: Output for one cell (variable LIST)


% fileName = 'C:\Users\Arseny\Documents\4_Chris Classification\BrownData v7.xlsx';  sheetNames{1} = 'Spikes';           % Old (Oct 09 2013)
fileName = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\Spikes data CURRENT.xlsx'; sheetNames{1} = 'SpikePerInjection'; % New (Aug 14 2014)

list = 22003;

        
temp = xlsread(fileName, sheetNames{1});
% temp = temp(1:13,:); %%% --- for debugging only!

row1 = 3;                           % First row of real data
maxX = 180;
aId = temp(row1:end,1);             % Cut the 1st row as it's all titles. Ids to one var
dataS = temp(row1:end,(1:10)+2);    % Data to another var.
x = temp(2,(1:10)+2);               % Store the currents as well.

xx = linspace(min(x),max(x),100);
if(exist('list','var'))
    g = ismember(aId,list);
    aId = aId(g);
    dataS = dataS(g,:);
end

[n,l] = size(dataS);
oneGiantPlot = 1;                       % Whether you want all fit lines to be shown on one giant plot
if(oneGiantPlot)
    plotN = max(1,floor(sqrt(n)/1.3));  % Auto-Layout
    plotM = ceil(n/plotN);
else
    plotN = 5;                          % Several pages, but sane size of each fit
    plotM = 8;
end


% figure;                           % All data curves in one plot
% [~,ind] = sort(sum(dataS,2));
% dataS = dataS(ind,:);
% hold on;
% %plot(x,bsxfun(@plus,dataS,(1:n)'*0.05),'g.-');
% plot(x,dataS+randn(size(dataS))*0.2,'g.-');
% plot(x,mean(dataS),'ko-');
% xlabel('Current injection, pA');
% ylabel('N spikes (dithered)');
% hold off;
% return

fprintf('\n');

fprintf('Spikes / injection\n');
fprintf('      id\tmaxX\tmaxY\tthreshold\n');
figure;
for(q=1:n)
    if(sum(dataS(q,:))>0)                                       % There are spikes in this cell
        lowestSpike = x(find(dataS(q,:)>0,1,'first'));        % Lowest current that produces a spike
        [f,s] = myfittypes('2exp',maxX,lowestSpike);
        [c2,gof2] = fit(x',dataS(q,:)',f,s);    
        fmaxx = fminbnd(@(x)(-c2(x)),min(x),max(x));            % Using anonymous function to find curve maximum    

        if(~oneGiantPlot)
            if(mod(q,plotN*plotM)==1 && (q>1))
                figure;
            end
        end
    
        subplot(plotN,plotM,mod(q-1,plotN*plotM)+1);
        hold on;
        plot(xx,c2(xx'),'r-');
        plot(x,dataS(q,:),'b.');    
        plot(fmaxx,c2(fmaxx),'ko');
        if(plotN>3)                                             % Save space if the plot is too loaded with data
            set(gca,'FontSize',6);
            set(gca,'XTick',[]);        
        end
        title(aId(q));        
        hold off;
        drawnow;
        fprintf('%8d\t%5.1f\t%6.4f\t%5.1f\n',[aId(q) fmaxx c2(fmaxx) c2.a]); % Id, best_injection, best_Nspikes, threshold_injection
    else % No spikes in this cell
        subplot(plotN,plotM,q);
        text(0.5,0.5,':(');
        set(gca,'FontSize',6);
        title(aId(q));
        fprintf('%8d\t%5.1f\t%6.4f\t%5.1f\n',[aId(q) NaN 0 NaN]);
    end
end
% supertitle('Spikes / step injection');

end

function [f,s] = myfittypes(kind,maxX,lowestSpike)
switch(kind)
    case 'exp'
        f = fittype('exp((x-a)/b)*c+d','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   1   0   0],...
                       'Upper',     [maxX    maxX Inf Inf],...
                       'Startpoint',[0      10  1   1]);
    case '2exp' % -------------------------------------------------------------------------- This one
        f = fittype('max(0,exp(-(x-a)/b)-exp(-(x-a)/c))*d','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [0              0.1     0.1     0],...
                       'Upper',     [lowestSpike    Inf     Inf    Inf],...
                       'Startpoint',[-3             200     50      2]); % Some sane-looking curve
    case 'cutexp'
        f = fittype('max(0,exp((x-a)/b)-e)*c+d','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   1      0   0   0],...
                       'Upper',     [maxX    maxX   Inf Inf 1],...
                       'Startpoint',[0       10     1   1   0.1]);
    case 'sigmoid'
        f = fittype('c/(1+exp(-(x-a)/b)+d)','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   1   0   0],...
                       'Upper',     [maxX    maxX Inf Inf],...
                       'Startpoint',[0      10  1   1]);
       case 'sigmoidoid'
        f = fittype('c*exp(x/b1)./(1+exp(-(a-x)/b2))','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   .1      .1        0   ],...
                       'Upper',     [0     maxX    maxX     Inf ],...
                       'Startpoint',[-1       10     10       1   ]);
   case 'xexp'
        f = fittype('(x-a)*exp(-(x-b)/c)*d+e','independent','x');
        s = fitoptions('Method','NonlinearLeastSquares',...
                       'Lower',     [-maxX   -maxX   1   0   0],...
                       'Upper',     [maxX    maxX    maxX Inf Inf],...
                       'Startpoint',[0      0      100  1   1]);
end
end